

F0hat = function(input){pnorm(input)}


######################################################################

kfwerfun = function(z,i,j, N, pi0hat){
  out = choose(i,j)*(F0hat(z))^j*(1-F0hat(z))^(i-j)*choose(N,i)*(pi0hat)^i*(1-pi0hat)^(N-i)
  return(out)}

# Now write the functions for LHS ################################

F0hat = function(input){pnorm(input)}

PARF0hat = function(lower,upper){
  out = F0hat(upper)-F0hat(lower)
  return(out)}
  
PARpi0hat = function(zz,A0lower=-2,A0upper=2){
  out = min(1,sum(zz<A0upper & zz>A0lower)/(length(zz)*(PARF0hat(A0lower,A0upper))))
  return(out)}


PARkfwerfunLHS = function(z,i,j, N, pi0hat){
#  out = choose(i,j)*(F0hat(z))^j*(1-F0hat(z))^(i-j)*choose(N,i)*(pi0hat)^i*(1-pi0hat)^(N-i)
   out = exp(lchoose(i,j)+j*log(F0hat(z))+(i-j)*log(1-F0hat(z))+lchoose(N,i)+i*log(pi0hat)+(N-i)*log(1-pi0hat))
   return(out)}

PARfullkfwerfunLHS = function(z,k,N,zz){
 pi0hat = PARpi0hat(zz,A0lower=-2,A0upper=2)
 mysum= 0
  for(j in k:N){
    i=j
    while(i <= N){
      out = PARkfwerfunLHS(z=z,i=i,j=j,N=N,pi0hat=pi0hat)
      mysum = mysum + out
 #     print(out)
      i = i+1}
  }
return(mysum)
}

# Shortened version of the above for LHS #############################

sPARfullkfwerfunLHS = function(z,k,N,zz){
  pi0hat = PARpi0hat(zz,A0lower=-2,A0upper=2)
  mysum = 0
  for(i in k:N){
    p = F0hat(z)
    out = (1-pbinom((k-1),size=i,prob=p))*dbinom(i,size=N,prob=pi0hat)
    mysum = mysum+out
    i =i +1}
  return(mysum)
}

# compare
#PARfullkfwerfunLHS(-2,2,10,pi0hat=0.95)
#sPARfullkfwerfunLHS(-2,2,10,pi0hat=0.95)

# Now write the functions for RHS ################################

PARkfwerfunRHS = function(z,i,j, N, pi0hat){
#  out = choose(i,j)*(1-F0hat(z))^j*(F0hat(z))^(i-j)*choose(N,i)*(pi0hat)^i*(1-pi0hat)^(N-i)
   out = exp(lchoose(i,j)+j*log(1-F0hat(z))+(i-j)*log(F0hat(z))+lchoose(N,i)+i*log(pi0hat)+(N-i)*log(1-pi0hat))
  return(out)}

PARfullkfwerfunRHS = function(z,k,N,zz){
  pi0hat = PARpi0hat(zz,A0lower=-2,A0upper=2)
 mysum= 0
  for(j in k:N){
    i=j
    while(i <= N){
      out = PARkfwerfunRHS(z=z,i=i,j=j,N=N,pi0hat=pi0hat)
      mysum = mysum + out
      i = i+1}
  }
return(mysum)
}


# Shortened version of the above for RHS #############################

sPARfullkfwerfunRHS = function(z,k,N,zz){
  pi0hat = PARpi0hat(zz,A0lower=-2,A0upper=2)
  mysum = 0
  for(i in k:N){
    p = 1-F0hat(z)
    out = (1-pbinom((k-1),size=i,prob=p))*dbinom(i,size=N,prob=pi0hat)
    mysum = mysum+out
    i =i +1}
  return(mysum)
}


# compare
#PARfullkfwerfunRHS(-2,2,10,pi0hat=0.95)
#sPARfullkfwerfunRHS(-2,2,10,pi0hat=0.95)


EMPf0hat = function(input){out = locfdr(zz=input,plot=0, nulltype=1)
nulldensityvec = out$mat[,6]
nullatvec = out$mat[,1]
return(list(x=nullatvec,y=nulldensityvec))
}

# trapz comes from the pracma library

trapz = function (x, y){
    if (missing(y)) {
        if (length(x) == 0)
            return(0)
        y <- x
        x <- 1:length(x)
    }
    if (length(x) == 0)
        return(0)
    if (!(is.numeric(x) || is.complex(x)) || !(is.numeric(y) ||
        is.complex(y)))
        stop("Arguments 'x' and 'y' must be real or complex.")
    m <- length(x)
    xp <- c(x, x[m:1])
    yp <- c(numeric(m), y[m:1])
    n <- 2 * m
    p1 <- sum(xp[1:(n - 1)] * yp[2:n]) + xp[n] * yp[1]
    p2 <- sum(xp[2:n] * yp[1:(n - 1)]) + xp[1] * yp[n]
    return(0.5 * (p1 - p2))
}

EMPF0hat = function(input, zz){
  test=EMPf0hat(zz)
  myAUC = trapz(test$x[test$x<input],test$y[test$x<input])/trapz(test$x[test$x<10],test$y[test$x<10])
  return(myAUC)}

# EMPFOhat(2,zz=myz) is the CDF evaluated at 2 when using the myz vector of test statistics


EMPpi0hat = function(zz,A0lower=-2,A0upper=2){
  out = min(1,sum(zz<A0upper & zz>A0lower)/(length(zz)*(EMPF0hat(A0upper,zz)-EMPF0hat(A0lower,zz))))
  return(out)}

#### LHS ################################################################

EMPkfwerfunLHS = function(z,i,j,N,zz, FOHATval,PI0HATval){
  #out = choose(i,j)*(FOHATval)^j*(1-FOHATval)^(i-j)*choose(N,i)*(PI0HATval)^i*(1-PI0HATval)^(N-i)
  # the below out function is exp(log(out)) of the above, helps with choose(N,i) functions which Inf with big N
  out = exp(lchoose(i,j)+ j*log(FOHATval)+(i-j)*log(1-FOHATval)+lchoose(N,i)+i*log(PI0HATval)+(N-i)*log(1-PI0HATval))
  return(out)}

EMPfullkfwerfunLHS = function(z,k,N,zz){
 mysum= 0
 FOHATval = EMPF0hat(z,zz)
 PI0HATval = EMPpi0hat(zz)
   for(j in k:N){
    i=j
    while(i <= N){
      #out = EMPkfwerfunLHS(i=i,j=j,N=N, FOHATval=FOHATval,PI0HATval=PI0HATval)
      out = EMPkfwerfunLHS(z=z,i=i,j=j,N=N, zz=zz, FOHATval=FOHATval,PI0HATval=PI0HATval)
      mysum = mysum + out
      i = i+1
      #print(out)
    }
  }
return(mysum)
}

# Shortened version of the above for LHS #############################

sEMPfullkfwerfunLHS = function(z,k,N,zz){
  mysum = 0
  F0HATval = EMPF0hat(z,zz)
  PI0HATval = EMPpi0hat(zz)
  for(i in k:N){
    out = (1-pbinom((k-1),size=i,prob=F0HATval))*dbinom(i,size=N,prob=PI0HATval)
    mysum = mysum+out
    i =i +1}
  return(mysum)
}

# compare
#zz= rnorm(150)
#EMPfullkfwerfunLHS(-1,5,150,zz=zz)
#sEMPfullkfwerfunLHS(-1,5,50,zz=zz)



#### RHS ##############################################################

EMPkfwerfunRHS = function(z,i,j,N,zz, FOHATval,PI0HATval){
 # out = choose(i,j)*(1-FOHATval)^j*(FOHATval)^(i-j)*choose(N,i)*(PI0HATval)^i*(1-PI0HATval)^(N-i)
    # the below out function is exp(log(out)) of the above, helps with choose(N,i) functions which Inf with big N
out = exp(lchoose(i,j)+j*log(1-FOHATval)+(i-j)*log(FOHATval) + lchoose(N,i)+i*log(PI0HATval)+(N-i)*log(1-PI0HATval))
  return(out)}

EMPfullkfwerfunRHS = function(z,k,N,zz){
 mysum= 0
 FOHATval = EMPF0hat(z,zz)
 PI0HATval = EMPpi0hat(zz)
   for(j in k:N){
    i=j
    while(i <= N){
      out = EMPkfwerfunRHS(i=i,j=j,N=N, FOHATval=FOHATval,PI0HATval=PI0HATval)
      mysum = mysum + out
      i = i+1
#      print(i)
    }
  }
return(mysum)
}

# Shortened version of the above for RHS #############################

sEMPfullkfwerfunRHS = function(z,k,N,zz){
  mysum = 0
  F0HATval = 1- EMPF0hat(z,zz)
  PI0HATval = EMPpi0hat(zz)
  for(i in k:N){
    out = (1-pbinom((k-1),size=i,prob=F0HATval))*dbinom(i,size=N,prob=PI0HATval)
    mysum = mysum+out
    i =i +1}
  return(mysum)
}

# compare
#zz= rnorm(150)
#EMPfullkfwerfunRHS(-1,5,150,zz=zz)
#sEMPfullkfwerfunRHS(-1,5,50,zz=zz)


