### Use the code in BUMsims.R to build a simulation that looks at
### LHS kFWER ONLY using truth/parametric and empirical kFWERs
### for a variety of k's.

### for the empirical kFWERs keep track
### of all the estimates and show the shading
### between the 5th and 95th percentiles

rm(list=ls())

source("KFWERfuns.R")
library(locfdr)
library(MASS)

# 500 genes,
# 1000 MC simulations

N=500
nMC = 1000
grid = seq(-5,5, length=500)
pi0=.95

# Make figure showing distribution of z scores.#############################
 myind = rbinom(N,size=1,prob=pi0)
  N0 = sum(myind)
  myp=c()
  myp[myind==1] = runif(N0)
  myp[myind==0] = rbeta((N-N0),shape1=.3, shape2=5)
# now make the z values
myzNULL = qnorm(myp)
mypsig = myp[myind==0]
myzLHS = qnorm(mypsig)

myz = c(myzNULL,myzLHS)
#myz = qnorm(myp)


postscript("ONESIDEDBUMzscoreshist.ps", paper="letter")

truehist(myz, xlab="z values", ylab="density", ylim=c(0,.5), prob=T,nbins=50,xlim=c(-5,5), cex.lab=1.3)
par = dnorm(grid)
lines(grid,par,type="l", lwd=2)

emp = EMPf0hat(myz)
test=emp
scalef=trapz(test$x[test$x<10],test$y[test$x<10])
lines(emp$x,emp$y/scalef, type="l", col="red",lwd=2)

dev.off()
system("ps2pdf ONESIDEDBUMzscoreshist.ps")
###########################################################################


LHS.MCresults = RHS.MCresults = matrix(NA, nrow=nMC, ncol=length(grid))
EMPLHS.K1.MCresults =  matrix(NA, nrow=nMC, ncol=length(grid))
EMPLHS.K5.MCresults =  matrix(NA, nrow=nMC, ncol=length(grid))
EMPLHS.K20.MCresults = matrix(NA, nrow=nMC, ncol=length(grid))
EMPLHS.K50.MCresults = matrix(NA, nrow=nMC, ncol=length(grid))


PARLHS.K1.MCresults =  matrix(NA, nrow=nMC, ncol=length(grid))
PARLHS.K5.MCresults =  matrix(NA, nrow=nMC, ncol=length(grid))
PARLHS.K20.MCresults = matrix(NA, nrow=nMC, ncol=length(grid))
PARLHS.K50.MCresults = matrix(NA, nrow=nMC, ncol=length(grid))

for(i in 1:nMC){
  
  myind = rbinom(N,size=1,prob=pi0)
  N0 = sum(myind)
  myp=c()
  myp[myind==1] = runif(N0)
  myp[myind==0] = rbeta((N-N0),shape1=.3, shape2=5)
  myz = qnorm(myp)

   for(j in 1:length(grid)){
    LHS.MCresults[i,j] = sum(myz[myind==1] <= grid[j])
    RHS.MCresults[i,j] = sum(myz[myind==1] >= grid[j])
    EMPLHS.K1.MCresults[i,j] = sEMPfullkfwerfunLHS(z=grid[j],k=1,N=N,zz=myz)
    EMPLHS.K5.MCresults[i,j] = sEMPfullkfwerfunLHS(z=grid[j],k=5,N=N,zz=myz)
    EMPLHS.K20.MCresults[i,j] = sEMPfullkfwerfunLHS(z=grid[j],k=20,N=N,zz=myz)
    EMPLHS.K50.MCresults[i,j] = sEMPfullkfwerfunLHS(z=grid[j],k=50,N=N,zz=myz)
    
   PARLHS.K1.MCresults[i,j] = sPARfullkfwerfunLHS(z=grid[j],k=1,N=N,zz=myz)
        PARLHS.K5.MCresults[i,j] = sPARfullkfwerfunLHS(z=grid[j],k=5,N=N,zz=myz)
        PARLHS.K20.MCresults[i,j] = sPARfullkfwerfunLHS(z=grid[j],k=20,N=N,zz=myz)
        PARLHS.K50.MCresults[i,j] = sPARfullkfwerfunLHS(z=grid[j],k=50,N=N,zz=myz)
    
          }
  print(i)
  }

#### Now get the quantiles for the empirical kFWER LHS and kFWER RHS
 
LHSk1ninetyfivepercent =LHSk1fivepercent = c()
LHSk5ninetyfivepercent =LHSk5fivepercent = c()
LHSk20ninetyfivepercent =LHSk20fivepercent = c()
LHSk50ninetyfivepercent =LHSk50fivepercent = c()


for(i in 1:dim(EMPLHS.K1.MCresults)[2]){
#k =1
LHSmyvec = EMPLHS.K1.MCresults[,i]

LHSk1fivepercent[i] = quantile(LHSmyvec,.05, na.rm=T)
LHSk1ninetyfivepercent[i] = quantile(LHSmyvec,.95, na.rm=T)

#k =5
LHSmyvec = EMPLHS.K5.MCresults[,i]

LHSk5fivepercent[i] = quantile(LHSmyvec,.05, na.rm=T)
LHSk5ninetyfivepercent[i] = quantile(LHSmyvec,.95, na.rm=T)

# k = 20
LHSmyvec = EMPLHS.K20.MCresults[,i]

LHSk20fivepercent[i] = quantile(LHSmyvec,.05, na.rm=T)
LHSk20ninetyfivepercent[i] = quantile(LHSmyvec,.95, na.rm=T)

# k = 50
LHSmyvec = EMPLHS.K50.MCresults[,i]

LHSk50fivepercent[i] = quantile(LHSmyvec,.05, na.rm=T)
LHSk50ninetyfivepercent[i] = quantile(LHSmyvec,.95, na.rm=T)
}


# add Sidak/Bonf cutpoints

f.bin.jcm = function(N, k, con.rate = .95){
   f. = function(alpha.tilde) pbinom(k-1,N,alpha.tilde) - con.rate  
   uniroot(f.,interval=c(.00001/N,1))$root
}

returnpcut = function(N,K, alpha){
 f.bin.jcm(N,K, con.rate=1-alpha)
}

# Add Holm Cutpoint based on the mean p-value for cutting.  Note this
# requires resimulated the data.

K=c(1,5,20,50)
nMC=5000
holmpval = matrix(NA,nrow=nMC,ncol=length(K))
for(j in 1:length(K)){
for(i in 1:nMC){
  
  myind = rbinom(N,size=1,prob=pi0)
  N0 = sum(myind)
  myp=c()
  myp[myind==1] = runif(N0)
  myp[myind==0] = rbeta((N-N0),shape1=.3, shape2=5)
  myz = qnorm(myp)
  pval.o = sort(myp)
#  Holm.alpha = c(rep(K[j]*0.20/N, K[j]), K*0.20/(N+K[j]-seq(K[j]+1,N-K[j])))
  ntimes = N-K[j]
  Holm.alpha = c(rep((K[j]*0.20/N), K[j]), rep((K[j]*0.20),ntimes)/(N+K[j]-seq(K[j]+1,N)))
  temp = which(pval.o<Holm.alpha)
  if(length(temp)==0){holmpval[i,j]=0}
  if(length(temp)!=0){holmpval[i,j]=max(pval.o[temp])}
}}

  # MCs are the rows, cols refer to K for holmpval
    holmmean = colMeans(holmpval)
    zholmmean = qnorm(holmmean)

##############################################################
##############################################################
### Now make figure
##############################################################
##############################################################

# for k = 1 ############################################ 

k=1
LHSestkFWER = colMeans(PARLHS.K1.MCresults)

LHSkfwer=c()
for(i in 1:dim(LHS.MCresults)[2]){
  LHSkfwer[i] = mean(LHS.MCresults[,i] >= k)
}

postscript("ONESIDEDkfwerfigWITHEMP.ps", paper="letter")
par(mfrow=c(2,2))

plot(grid,LHSkfwer,type="n", main="k=1", xlab="z-values", ylab = "(LHS) k-FWER", xlim=c(-5,0))
axis(side=4)
# and EMP's and shading
polygon(c(grid[grid<0],sort(grid[grid<0], decreasing=T)), c(LHSk1ninetyfivepercent[grid<0],sort(LHSk1fivepercent[grid<0], decreasing=T)), col="gray", border=F)

lines(grid[grid<0], LHSkfwer[grid<0],col=1,lwd=2, lty=1)
lines(grid[grid<0], LHSestkFWER[grid<0],col=1,lwd=2, lty=2)

###########
pboncut = 1*0.2/N
psidakcut = returnpcut(N=N,alpha=0.2,K=1)

LHSzboncut= qnorm(pboncut)
LHSzsidakcut = qnorm(psidakcut)

# boncut line LHS
ycut = min(LHSkfwer[grid>LHSzboncut & grid<0])
segments(x0 = LHSzboncut, x1=LHSzboncut,y0=0,  y1= ycut, lty=2,col="green",lwd=2)
segments(x0 = -5, x1=LHSzboncut,y0=ycut,  y1= ycut, lty=2,col="green",lwd=2)
# sidak cut LHS
ycut = min(LHSkfwer[grid>LHSzsidakcut & grid<0])
segments(x0 = LHSzsidakcut, x1=LHSzsidakcut,y0=0,  y1= ycut, lty=2,col="red",lwd=2)
segments(x0 = -5, x1=LHSzsidakcut,y0=ycut,  y1= ycut, lty=2,col="red",lwd=2)
# holm cut LHS
ycut = min(LHSkfwer[grid>zholmmean[1] & grid<0])
segments(x0 = zholmmean[1], x1=zholmmean[1],y0=0,  y1= ycut, lty=2,col="blue",lwd=2)
segments(x0 = -5, x1=zholmmean[1],y0=ycut,  y1= ycut, lty=2,col="blue",lwd=2)

# for k = 5 ############################################

k=5
LHSestkFWER = colMeans(PARLHS.K5.MCresults)

LHSkfwer=RHSkfwer=c()
for(i in 1:dim(LHS.MCresults)[2]){
  LHSkfwer[i] = mean(LHS.MCresults[,i] >= k)
}

plot(grid,LHSkfwer,type="n", main="k=5", xlab="z-values", ylab = "(LHS) k-FWER", xlim=c(-5,0))
# and EMP's and shading
polygon(c(grid[grid<0],sort(grid[grid<0], decreasing=T)), c(LHSk5ninetyfivepercent[grid<0],sort(LHSk5fivepercent[grid<0], decreasing=T)), col="gray", border=F)


lines(grid[grid<0], LHSkfwer[grid<0],col=1,lwd=2, lty=1)
lines(grid[grid<0], LHSestkFWER[grid<0],col=1,lwd=2, lty=2)

###########
pboncut = (5*0.2)/N
psidakcut = returnpcut(N=N,alpha=0.2,K=5)

LHSzboncut= qnorm(pboncut)
LHSzsidakcut = qnorm(psidakcut)

# boncut line
ycut = min(LHSkfwer[grid>LHSzboncut & grid<0])
segments(x0 = LHSzboncut, x1=LHSzboncut,y0=0,  y1= ycut, lty=2,col="green",lwd=2)
segments(x0 = -5, x1=LHSzboncut,y0=ycut,  y1= ycut, lty=2,col="green",lwd=2)
# sidak cut
ycut = min(LHSkfwer[grid>LHSzsidakcut & grid<0])
segments(x0 = LHSzsidakcut, x1=LHSzsidakcut,y0=0,  y1= ycut, lty=2,col="red",lwd=2)
segments(x0 = -5, x1=LHSzsidakcut,y0=ycut,  y1= ycut, lty=2,col="red",lwd=2)
# holm cut LHS
ycut = min(LHSkfwer[grid>zholmmean[2] & grid<0])
segments(x0 = zholmmean[2], x1=zholmmean[2],y0=0,  y1= ycut, lty=2,col="blue",lwd=2)
segments(x0 = -5, x1=zholmmean[2],y0=ycut,  y1= ycut, lty=2,col="blue",lwd=2)


# for k = 20 ###########################################

k=20
LHSestkFWER = colMeans(PARLHS.K20.MCresults)

LHSkfwer=RHSkfwer=c()
for(i in 1:dim(LHS.MCresults)[2]){
  LHSkfwer[i] = mean(LHS.MCresults[,i] >= k)
}

plot(grid,LHSkfwer,type="n", main="k=20", xlab="z-values", ylab = "(LHS) k-FWER", xlim=c(-5,0))
# and EMP's and shading
polygon(c(grid[grid<0],sort(grid[grid<0], decreasing=T)), c(LHSk20ninetyfivepercent[grid<0],sort(LHSk20fivepercent[grid<0], decreasing=T)), col="gray", border=F)

lines(grid[grid<0], LHSkfwer[grid<0],col=1,lwd=2, lty=1)
lines(grid[grid<0], LHSestkFWER[grid<0],col=1,lwd=2, lty=2)

###########
pboncut = 20*0.2/N
psidakcut = returnpcut(N=N,alpha=0.2,K=20)

LHSzboncut= qnorm(pboncut)
LHSzsidakcut = qnorm(psidakcut)

# boncut line
ycut = min(LHSkfwer[grid>LHSzboncut & grid<0])
segments(x0 = LHSzboncut, x1=LHSzboncut,y0=0,  y1= ycut, lty=2,col="green",lwd=2)
segments(x0 = -5, x1=LHSzboncut,y0=ycut,  y1= ycut, lty=2,col="green",lwd=2)
# sidak cut
ycut = min(LHSkfwer[grid>LHSzsidakcut & grid<0])
segments(x0 = LHSzsidakcut, x1=LHSzsidakcut,y0=0,  y1= ycut, lty=2,col="red",lwd=2)
segments(x0 = -5, x1=LHSzsidakcut,y0=ycut,  y1= ycut, lty=2,col="red",lwd=2)
# holm cut LHS
ycut = min(LHSkfwer[grid>zholmmean[3] & grid<0])
segments(x0 = zholmmean[3], x1=zholmmean[3],y0=0,  y1= ycut, lty=2,col="blue",lwd=2)
segments(x0 = -5, x1=zholmmean[3],y0=ycut,  y1= ycut, lty=2,col="blue",lwd=2)


# for k = 50 ##########################################

k=50
LHSestkFWER = colMeans(PARLHS.K50.MCresults)

LHSkfwer=c()
for(i in 1:dim(LHS.MCresults)[2]){
  LHSkfwer[i] = mean(LHS.MCresults[,i] >= k)
}

plot(grid,LHSkfwer,type="n", main="k=50", xlab="z-values", ylab = "(LHS) k-FWER", xlim=c(-5,0))
# and EMP's and shading
polygon(c(grid[grid<0],sort(grid[grid<0], decreasing=T)), c(LHSk50ninetyfivepercent[grid<0],sort(LHSk50fivepercent[grid<0], decreasing=T)), col="gray", border=F)

lines(grid[grid<0], LHSkfwer[grid<0],col=1,lwd=2, lty=1)
lines(grid[grid<0], LHSestkFWER[grid<0],col=1,lwd=2, lty=2)

###########
pboncut = 50*0.2/N
psidakcut = returnpcut(N=N,alpha=0.2,K=50)

LHSzboncut= qnorm(pboncut)
LHSzsidakcut = qnorm(psidakcut)

# boncut line
ycut = min(LHSkfwer[grid>LHSzboncut & grid<0])
segments(x0 = LHSzboncut, x1=LHSzboncut,y0=0,  y1= ycut, lty=2,col="green",lwd=2)
segments(x0 = -5, x1=LHSzboncut,y0=ycut,  y1= ycut, lty=2,col="green",lwd=2)
# sidak cut
ycut = min(LHSkfwer[grid>LHSzsidakcut & grid<0])
segments(x0 = LHSzsidakcut, x1=LHSzsidakcut,y0=0,  y1= ycut, lty=2,col="red",lwd=2)
segments(x0 = -5, x1=LHSzsidakcut,y0=ycut,  y1= ycut, lty=2, col="red", lwd=2)
# holm cut LHS
ycut = min(LHSkfwer[grid>zholmmean[4] & grid<0])
segments(x0 = zholmmean[4], x1=zholmmean[4],y0=0,  y1= ycut, lty=2,col="blue",lwd=2)
segments(x0 = -5, x1=zholmmean[4],y0=ycut,  y1= ycut, lty=2,col="blue",lwd=2)

dev.off()
system("ps2pdf ONESIDEDkfwerfigWITHEMP.ps")

save.image(file = "ONESIDEDBUMsims.Rdata")


