#####################################################
#####################################################
### DESMEDT #########################################
#####################################################
#####################################################

library(pseudo)
library(KMsurv)
library(survival)

load("Desmedtdatamatrix.Rdata")
exprMat = as.matrix(data)

### Create the Pseudo outcome vector ###########

mysurv <- survfit(surv ~ 1)
plot(mysurv)
cutoffs <- c(median(surv[,1]))  
#Calculate pseudovalue at approx median survival time (Will vary with data set)
pseudo <- pseudosurv(surv[,1],surv[,2], tmax=cutoffs)$pseudo
dat=list()
dat$time = surv[,1]
dat$status=surv[,2]
dat$pseudo <- pseudo
write.table(dat, file="DesmedtSurvivalPseudo.txt")

#######################################
### Now compute W matrix
#######################################

y = pseudo - mean(pseudo)
varx  = var(t(exprMat))

myy =y

COR.Y = function(x,y=myy){cor(x,y)}

L = apply(exprMat, 1, FUN=COR.Y)
Lmat = matrix(0,nrow=dim(varx)[1],ncol=dim(varx)[1])
diag(Lmat) = L

Right = varx %*% Lmat
w = Lmat %*% Right

###########################################
# Transform the negatives in W to 0
###########################################

test = unlist(w)
test[test<0] = 0

w = matrix(test,byrow=F, nrow=22283)

##################################################
# Now compute w0 matrix as w0 = w-diag(w)
##################################################

# Note, may have to remove some variables here

sub = matrix(0, nrow=dim(w)[1],ncol=dim(w)[1])
diag(sub) = diag(w)

w0 = w-sub

##########################################
# we want the first eigenvector of w0
##########################################

### See this webpage for example of using igraph and arpack
### http://www.r-bloggers.com/using-arpack-to-compute-the-largest-eigenvalue-of-a-matrix/

library(igraph)
func <- function(x, extra=NULL) { 
as.vector(w0 %*% x) } 
myeig = arpack(func, sym=T, options=list(n=22283,nev=1, which="LM", maxiter=200))
myvec = myeig$vector

write.table(myvec,file="firsteigenvecDESMEDT.txt", row.names=F,col.names=F, quote=F)

# myvec = eigen(w0)

######################################################################
######################################################################
### NOW keep track of ALL (actually just first 5) eigenvectors in EACH BS
### Below chunk was run in testBSwithpython.R ########################
######################################################################

##################################################################### 
### Note, we only computed 5 eigenvectors due to time/size issues
### Should be OK since the largest correlation is observed for the 
### first eigenvector in many of the test sims
######################################################################
######################################################################

B=200
for(k in 1:B){
 BSsamp = sample(seq(1,198),size=198,replace=T)
 ps=read.table(file="DesmedtSurvivalPseudo.txt")
 BSpseudo = ps$pseudo[BSsamp]
 BSy = BSpseudo - mean(BSpseudo)
 load("Desmedtdatamatrix.Rdata")
 exprMat = as.matrix(data)
 BSexprMat = exprMat[,BSsamp]
 
 rm(list=c("data","exprMat"))
 BSvarx  = var(t(BSexprMat))
 size=22283
################################################# 
myy = BSy

COR.Y = function(x,y=myy){cor(x,y)}
L = apply(BSexprMat, 1, FUN=COR.Y)

rm(list=c("BSesprMat","BSpseudo","BSsamp", "BSy","myy","ps","size","surv"))

Right = sweep(BSvarx,MARGIN=1,STATS =L, FUN="*")
rm(list="BSvarx")
BSw = sweep(Right, MARGIN=2, STATS=L, FUN="*")
rm(list=c("Right","L"))


###########################################
# Transform the negatives in W to 0
###########################################

test = unlist(BSw)
test[test<0] = 0

BSw = matrix(test,byrow=F, nrow=22283)
rm(list=c("test")
##################################################
# Now compute w0 matrix as w0 = w-diag(w)
##################################################

# Note, may have to remove some variables here

sub = matrix(0, nrow=dim(BSw)[1],ncol=dim(BSw)[1])
diag(sub) = diag(BSw)

BSw0 = BSw-sub

rm(list=c("BSw"))

# compute eigen vecs

 library(igraph)
 func <- function(x, extra=NULL) { 
 as.vector(BSw0 %*% x) } 
 myeig = arpack(func, sym=T, options=list(n=22283,nev=5, ncv=10, which="LM", maxiter=200))
 BSmymat = myeig$vector
 # BSmymat is a matrix with 222283 rows and nev columns
 mylab = paste("WALLBSit",k,".txt",sep="")
 write.table(BSmymat,file=mylab,quote=F,row.names=F,col.names=F, sep="\t")
 print(k)
 rm(list=ls())
}
###################################################################################
###################################################################################
###################################################################################

###################################################################################
###################################################################################
### Process all of the above information in WALLBSitXXX.txt files
### 1. Assess what eigenvector in each file has the highest correlation
###################################################################################
###################################################################################

myabscor=c()
for(k in 1:200){

myfile = paste("WALLBSit",k,".txt",sep="")
test = read.table(myfile)
real = read.table("firsteigenvecDESMEDT.txt")
real = unlist(real)
mycor=c()
for(i in 1:5){mycor[i] = cor(test[,i],real)}
 abscor = abs(mycor)
max(abscor)
myabscor[k]=which(abscor==max(abscor))
print(k)
}

### From examining myabscor
### (nearly) all the max correlations occur with the first eigenvector of the BS samples ########
### However some are positive and some are negative and make sure we multiply
### the negatives by -1.

mymat=c()
real = read.table("firsteigenvecDESMEDT.txt")
for(k in 1:200){
   myfile = paste("WALLBSit",k,".txt",sep="")
   test = read.table(myfile)
   # myabscor[k] is the eigenvector we are interested in
   BSeig=test[,myabscor[k]]
   mycor = cor(real,BSeig)
   print(mycor)
   if(mycor<0){BSeig=-1*BSeig}
   mymat = cbind(mymat,BSeig)   
}

finaleig = rowMeans(mymat)

km = kmeans(finaleig,2)

########################################################################
#### Now make the heatmap
########################################################################

library("gplots")
load("Desmedt.Rdata")

sigobs=which(km$cluster==1)

### Note there are 1222 significant genes in a pathway

sigeig = finaleig[sigobs]
mypathway = rownames(data)[km$cluster==1]

mytop=30
topobs = order(sigeig,decreasing=T)[1:mytop]
toppath = mypathway[topobs]

linker = match(toppath,row.names(data))
mymat = data[linker,]
mymat = as.matrix(mymat)
rm("data")

dps=read.table("DesmedtSurvivalPseudo.txt")
#addvec=dps[,1] # this is survival
addvec=dps[,3] # this is pseudo

newmat = rbind(addvec,mymat)
my_palette <- colorRampPalette(c("red", "black", "green"))(n = 40)

postscript("BSversiondesmedt2.ps",paper="letter")
heatmap.2(newmat, Rowv=T, Colv=T, dendrogram='none',scale='row',breaks=seq(-3,3,length=41),rowsep=c(1), colsep=F, sepcolor="white", trace='none',col=my_palette,xlab="Samples",labCol=F,ylab="Genes",labRow=F)

text("Pseudo",x=.14,y=.78)
dev.off()
system("ps2pdf BSversiondesmedt2.ps")

