#
# Simreps.R
#
#===============================================================================================#
# 
# simulation functions for a set of simulations
#     call "Sim1Rep" many times (Nrep times) with designated seeds
#     return a 3-dim array  of Umat returned from "Sim1Rep" 
#
#===============================================================================================#

source("FMDfunctions.R")
source("Sim1Functions.R")

Nrep=400
seeds=1:Nrep

## set relevant parameters for the functional hub by specifying rm, SNR and alphaHub
par<-get.par(rm=0.1,SNR=.1,alphaHub=1) #
alphaHub=par$alphaHub
betaFHub=par$betaFHub
V.e=par$V.e

# Specify relevant parameters for the nonfunctional hub and functional independents
# When there is no functional independents, set alphaInd=0. 
# And the number of nonfunctional independents is pfi+pni

alphaInd=1 
betaNFHub=betaFHub

SimDatPars=list(n=100,pfh=20,pnh=20,mnh=4,pfi=20,pni=380,alphaHub=alphaHub,alphaInd=alphaInd,betaFHub=betaFHub,betaNFHub=betaNFHub,V.e=V.e,vrb=T)


MethodsList=list(list(method="W.e",methodLabel="W.1.1",methodPars=list(delta=1,gamma=1)),
		             list(method="W.bt",methodLabel="W.bt",methodPars=list(delta=1,gamma=1)),
        	       #list(method="WK.W",methodLabel="W.6",methodPars=list(delta=1,gamma=1,ncluster=6)),
                 list(method="WGCNA",methodLabel="WGCNA.1.6",methodPars=list(delta=1,ncluster=6)),
                 list(method="KMEANS",methodLabel="K2",methodPars=list(ncluster=2)),
                 #list(method="SPC",methodLabel="SPC") 
                 )


result=sapply(seeds,Sim1Rep,SimDatPars=SimDatPars,MethodsList=MethodsList,simplify="array")

# indicator variable = 1 if the variable belongs to the functional hub and 0 otherwise
truth<-(dimnames(result)[[1]]=="fh")*1

# calculate performance statistics
dimm <- dim(result)
emp <- matrix(NA,nrow=dimm[3],ncol=dimm[2])
colnames(emp) <- dimnames(result)[[2]]
rownames(emp) <- paste("sample", 1:dimm[3])
FPR.all <- TPR.all <- FDR.all <- emp

for (i in 1:dimm[2]){
  
  junk=apply(result[,i,],2,perf,truth=truth)
  FPR.all[,i]<-junk[1,]
  TPR.all[,i]<-junk[2,]
  FDR.all[,i]<-junk[3,]

}


# plot the results
methods<-dimnames(result)[[2]]
names<-as.factor(rep(methods,each=dim(result)[3]))

# plots of FPR
# combine all results from different methods into a data frame
comb<-data.frame(FPR= c(FPR.all),TPR=c(TPR.all),FDR=c(FDR.all),methods=factor(names,level=methods))
summaries=data.frame(stack(comb,select=c("FPR","TPR","FDR")),methods=rep(comb$methods,times=3))

# boxplots
bwplot(values ~ methods|ind, summaries,groups=ind,main="performance",layout=c(1,3)) 

# violin plots 
bwplot(values ~ methods|ind, summaries,groups=ind,main="performance",layout=c(1,3),panel = function(..., subscripts, groups, box.ratio) {
  panel.violin(..., col = "transparent",from=0,to=1,varwidth = FALSE, box.ratio = box.ratio)
  panel.bwplot(..., fill = NULL, box.ratio = .1)
} )

